/**
 * Appcelerator Titanium Mobile
 * Copyright (c) 2009-2010 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the Apache Public License
 * Please see the LICENSE included with this distribution for details.
 * 
 * WARNING: This is generated code. Modify at your own risk and without support.
 */
#ifdef USE_TI_UITOOLBAR

#import "TiUIToolbar.h"
#import "TiUIViewProxy.h"
#import "TiUtils.h"
#import "TiColor.h"
#import "TiToolbarButton.h"
#import "TiToolbar.h"

@implementation TiUIToolbar

-(void)dealloc
{
	[self performSelector:@selector(setItems_:) withObject:nil];
	RELEASE_TO_NIL(toolBar);
	[super dealloc];
}

-(UIToolbar *)toolBar
{
	if (toolBar == nil)
	{
		toolBar = [[UIToolbar alloc] initWithFrame:[self bounds]];
		[toolBar setAutoresizingMask:UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleBottomMargin];
		[self addSubview:toolBar];
		[self setClipsToBounds:YES];
	}
	return toolBar;
}

-(void)layoutSubviews
{
	CGRect ourBounds = [self bounds];
	CGFloat height = [self bounds].size.height;	
	if (height != [self verifyHeight:height])
	{
		[(TiViewProxy *)[self proxy] setNeedsReposition];
		return;
	}


	CGRect toolBounds = [[self toolBar] bounds];
	toolBounds.size = [toolBar sizeThatFits:toolBounds.size];
	CGPoint toolBarCenter = CGPointMake(ourBounds.size.width/2, toolBounds.size.height/2);
	if (hideTopBorder)
	{
		toolBarCenter.y -= 1.0;
	}

	[toolBar setBounds:toolBounds];
	[toolBar setCenter:toolBarCenter];
}


-(void)drawRect:(CGRect)rect
{
	[super drawRect:rect];
	if (!showBottomBorder)
	{
		return;
	}

	CGRect toolFrame = [TiUtils viewPositionRect:toolBar];

    CGContextRef context = UIGraphicsGetCurrentContext();
    CGContextSetGrayStrokeColor(context, 0.0, 1.0);
	CGPoint bottomBorder[2];
	
	CGFloat x = toolFrame.origin.x;
	CGFloat y = toolFrame.origin.y+toolFrame.size.height+1;
	bottomBorder[0]=CGPointMake(x,y);
	x += toolFrame.size.width;
	bottomBorder[1]=CGPointMake(x,y);
	CGContextStrokeLineSegments(context,bottomBorder,2);
}


-(void)setItems_:(id)value
{
	ENSURE_TYPE_OR_NIL(value,NSArray);
	if (value!=nil)
	{
		NSMutableArray * result = [NSMutableArray arrayWithCapacity:[value count]];
		Class proxyClass = [TiViewProxy class];
		for (TiUIViewProxy * thisProxy in value) {
			ENSURE_CLASS(thisProxy,proxyClass);
			if (![thisProxy supportsNavBarPositioning])
			{
				//TODO: This is an exception that should have been raised long ago.
				NSLog(@"[ERROR] %@ does not support being in a toolbar!",thisProxy);
				//continue;
			}
			if ([thisProxy conformsToProtocol:@protocol(TiToolbarButton)])
			{
				[(id<TiToolbarButton>)thisProxy setToolbar:(TiToolbar*)self.proxy];
			}
			[result addObject:[thisProxy barButtonItem]];
			
		}
		[[self toolBar] setItems:result];
	}
	else 
	{
		UIToolbar *toolbar = [self toolBar];
		if (toolbar!=nil)
		{
			for (id thisProxy in [toolbar items])
			{
				if ([thisProxy conformsToProtocol:@protocol(TiToolbarButton)])
				{
					[(id<TiToolbarButton>)thisProxy setToolbar:nil];
				}
			}
		}
		[toolbar setItems:nil];
	}
}

-(void)setBorderTop_:(id)value
{
	hideTopBorder = ![TiUtils boolValue:value def:YES];
	[(TiViewProxy *)[self proxy] setNeedsReposition];
	//The default is that a top border exists.
}

-(void)setBorderBottom_:(id)value
{
	showBottomBorder = [TiUtils boolValue:value def:NO];
	[(TiViewProxy *)[self proxy] setNeedsReposition];
	//The default is that there is no bottom border.
}

-(void)setBarColor_:(id)value
{
	TiColor * newBarColor = [TiUtils colorValue:value];
	
	[[self toolBar] setBarStyle:[TiUtils barStyleForColor:newBarColor]];
	[toolBar setTintColor:[TiUtils barColorForColor:newBarColor]];
	[toolBar setTranslucent:[TiUtils barTranslucencyForColor:newBarColor]];
}

-(void)setTranslucent_:(id)value
{
	[toolBar setTranslucent:[TiUtils boolValue:value]];
}


-(void)frameSizeChanged:(CGRect)frame bounds:(CGRect)bounds
{
	[super frameSizeChanged:frame bounds:bounds];
	CGFloat height = bounds.size.height;
	
	if (height != [self verifyHeight:height])
	{
		[(TiViewProxy *)[self proxy] setNeedsReposition];
	}
}


-(CGFloat)verifyHeight:(CGFloat)suggestedHeight
{
	CGFloat result = [[self toolBar] sizeThatFits:CGSizeZero].height;
	if (hideTopBorder)
	{
		result -= 1.0;
	}
	if (showBottomBorder)
	{
		result += 1.0;
	}
	return result;
}

@end

#endif